<?php
/**
 * Helper file to register schemas
 *
 * @package Mint\MRM\DataBase
 * @namespace Mint\MRM\DataBase
 */

namespace MailMintPro\Mint\DataBase;

/**
 * Model class
 *
 * This class is using to be the parent of direct interaction models with the database where we are registering all the models
 *
 * @package Mint\MRM\DataBase
 * @namespace Mint\MRM\DataBase
 *
 * @version 1.5.0
 */
class Model {

	/**
	 * Retrieves the list of database tables used by the plugin.
	 *
	 * @return array An associative array of database tables, where the keys represent.
	 * @since 1.5.0
	 * @since 1.11.0 Added LeadMagnet table.
	 */
	public static function get_tables() {
		return apply_filters(
			'mrm_pro_database_tables',
			array(
				'webhook'        => 'WebHook',
				'abandoned_cart' => 'AbandonedCart',
				'lead_magnet'    => 'LeadMagnet',
				'link_trigger'   => 'LinkTrigger',
			)
		);
	}
}
