<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/DataStores
 */

namespace MailMintPro\Mint\DataStores;

/**
 * [Manage note data]
 *
 * @desc Manage plugin's assets
 * @package /app/DataStores
 * @since 1.0.0
 */
class WebHookData {
	/**
	 * Note_type
	 *
	 * @var string $name
	 * @since 1.0.0
	 */
	private $name;

	/**
	 * Get hash
	 *
	 * @var string $hash
	 */
	private $hash;

	/**
	 * Webhook Setting.
	 *
	 * @var array $settings Get setting.
	 * @since 1.0.0
	 */
	private $settings;

	/**
	 * Webhook Topic
	 *
	 * @var $topic
	 * @since 1.0.0
	 */
	private $topic;

	/**
	 * Webhook failure_count
	 *
	 * @var $failure_count
	 * @since 1.0.0
	 */
	private $failure_count;

	/**
	 * Function construct.
	 *
	 * @param array $args Get Default data.
	 */
	public function __construct( $args ) {
		$this->name          = isset( $args[ 'name' ] ) ? $args[ 'name' ] : null;
		$this->hash          = isset( $args[ 'hash' ] ) ? $args[ 'hash' ] : null;
		$this->settings      = isset( $args[ 'settings' ] ) ? $args[ 'settings' ] : array();
		$this->topic         = isset( $args[ 'topic' ] ) ? $args[ 'topic' ] : 'contact';
		$this->failure_count = isset( $args[ 'failure_count' ] ) ? $args[ 'failure_count' ] : 0;
	}


	/**
	 * Return Webhook name
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_name() {
		return $this->name;
	}


	/**
	 * Web hook hash
	 *
	 * @return mixed|string
	 */
	public function get_hash() {
		return $this->hash;
	}


	/**
	 * Return note description
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_settings() {
		if ( ! is_serialized( $this->settings ) ) {
			return maybe_serialize( $this->settings );
		}
	}


	/**
	 * Return note status
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_topic() {
		return $this->topic;
	}


	/**
	 * Return note access
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_failure_count() {
		return $this->failure_count;
	}
}
