<?php
/**
 * App Class for Create Instance
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app
 */

namespace MailMintPro\Mint;

use MailMintPro\MailMintLicense;
use MailMintPro\Mint\Internal\AbandonedCart\AbandonedCart;
use MailMintPro\Mint\DataBase\Migration\DatabaseMigrator;
use MailMintPro\Mint\Internal\Admin\EmailTemplates\DefaultEmailTemplates;
use MailMintPro\Mint\Internal\Frontend\FrontendAssets;
use MailMintPro\Mint\Internal\Integrations;
use MailMintPro\Mint\Internal\Automation\AutomationRecipe;
use MailMintPro\MintAdmin\API\Server;
use MailMintPro\Mint\Internal\Traits\Singleton;
use MintMailPro\App\Actions\Hooks;
use MailMintPro\Mint\Internal\FormBuilderHook;
use MintMailPro\App\Actions\WebHooks;
use MRM\Common\MrmCommon;

/**
 * MRM App class.
 *
 * @since 1.0.0
 */
class App {

	use Singleton;

	/**
	 * Init the plugin
	 *
	 * @since 1.0.0
	 */
	public function init() {
		add_action( 'mailmint_loaded', array( $this, 'mintmail_plugin_loaded' ), -1 );

		// Initialize Hooks class for WP actions.
		new Hooks();
		new MailMintLicense();
		new Integrations();
	}


	/**
	 * Hook into actions and filters.
	 *
	 * @since 1.0.0
	 */
	public function init_hooks() {
		add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ), -1 );
		add_action( 'init', array( $this, 'init_mail_mint' ), 0 );
		add_action( 'in_plugin_update_message-mail-mint-pro/mail-mint-pro.php', array( $this, 'mail_mint_pro_plugin_update_message' ), 10, 2 );
		add_action( 'init', array( $this, 'mail_mint_pro_localization_setup' ) );
	}

	/**
	 * Mail Mint Pro localization setup.
	 *
	 * Description: Loads the localization files for Mail Mint Pro.
	 *
	 * @access public
	 * @since 1.7.2
	 */
	public function mail_mint_pro_localization_setup() {
		load_plugin_textdomain( 'mailmint-pro', false, 'mail-mint-pro' . '/languages/' );
	}

	/**
	 * Display a warning message in the WordPress admin area when there's a plugin update.
	 *
	 * @access public
	 *
	 * @param array  $data     An array of update data.
	 * @param object $response The update response object.
	 *
	 * @return void
	 * @since 1.5.6
	 */
	public function mail_mint_pro_plugin_update_message( $data, $response ) {
		if ( isset( $data['upgrade_notice'] ) ) {
			$msg = str_replace( array( '<p>', '</p>' ), array( '<div>', '</div>' ), $data['upgrade_notice'] );
			?>
				<hr class="e-major-update-warning__separator" />
				<div class="e-major-update-warning">
					<div class="e-major-update-warning__icon">
						<i class="eicon-info-circle"></i>
					</div>
					<div>
						<div class="e-major-update-warning__title">
							<?php echo esc_html__( 'Heads up, Please backup before upgrade!', 'mailmint-pro' ); ?>
						</div>
						<div class="e-major-update-warning__message">
							<?php
								printf( wp_kses_post( wpautop( $msg ) ) );
							?>
						</div>
					</div>
				</div>
			<?php
		}
	}

	/**
	 * MailMint plugin Loaded Callback Function.
	 *
	 * @return void
	 */
	public function mintmail_plugin_loaded() {
		$this->init_hooks();

		// Initialize API.
		Server::get_instance();
		$class_name = 'MailMintPro\\Mint\\Internal\\AutomationHooks';
		if ( class_exists( $class_name ) ) {
			$class_name::get_instance()->init();
		}

		if ( class_exists( 'MailMintPro\\App\\Internal\\Automation\\AutomationManager' ) ) {
			new \MailMintPro\App\Internal\Automation\AutomationManager();
		}

		FormBuilderHook::get_instance()->init();
		AutomationRecipe::get_instance()->init();

		DefaultEmailTemplates::get_instance()->init();
		new WebHooks();
		if ( MrmCommon::is_wc_active() ) {
			new AbandonedCart();
		}
		DatabaseMigrator::get_instance()->init();
	}

	/**
	 * Plugin Loaded.
	 *
	 * @return void
	 */
	public function on_plugins_loaded() {
	}

	/**
	 * Initializes the Mail Mint feature by registering a new admin menu page and enqueueing necessary assets.
	 * This function is responsible for hooking into the 'admin_menu' and 'admin_enqueue_scripts' actions, and calling the
	 * 'register_page' and 'enqueue_admin_assets' methods respectively. These methods are defined within the class to
	 * register the new admin menu page and enqueue the necessary JavaScript and CSS assets.
	 *
	 * @return void
	 */
	public function init_mail_mint() {
		add_action( 'admin_menu', array( $this, 'register_page' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_assets' ) );
		new FrontendAssets();
	}

	/**
	 * [Register menus]
	 *
	 * @desc Register menus
	 * @since 1.0.0
	 */
	public function register_page() {
		add_submenu_page(
			'mrm-admin',
			__( 'License', 'mailmint-pro' ),
			__('License', 'mailmint-pro' ),
			'mint_manage_license',
			'mail-mint-licence',
			array( $this, 'mailmint_licence_page' )
		);
	}

	/**
	 * [Loads plugin default wrapper]
	 *
	 * @desc Loads plugin default wrapper
	 * @return void
	 * @since 1.0.0
	 */
	public function mailmint_licence_page() {
		require MAIL_MINT_PRO_DIR_PATH . 'app/Internal/Admin/Licence/licence.php';
	}

	/**
	 * Check the type of the request
	 *
	 * @param string $type get request type .
	 * @return bool
	 * @since 1.0.0
	 */
	private function is_request( $type ) {
		switch ( $type ) {
			case 'admin':
				return is_admin();
			case 'ajax':
				return defined( 'DOING_AJAX' );
			case 'cron':
				return defined( 'DOING_CRON' );
			case 'frontend':
				return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
		}
	}


	/**
	 * Enqueue admin styles and scripts.
	 *
	 * @param string $hook Get Admin page.
	 * @since 1.0.0
	 */
	public function enqueue_admin_assets( $hook ) {
		$plugin_url = plugin_dir_url( __FILE__ );

		if ( 'mail-mint_page_mail-mint-licence' === $hook ) {
			wp_enqueue_style( 'mail-mint-pro', $plugin_url . 'Internal/assets/css/mail-mint-pro.css' ); //phpcs:ignore
		}
	}


}
