<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-07-20 11:03:17
 * @modify date 2023-07-20 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MailMintPro\Mint\Admin\API\Controllers\WPController;
use WP_REST_Server;

/**
 * Class ContactExportRoute
 *
 * Summary: Contact Export Route.
 * Description: Extends the AdminRoute class and handles API endpoints for exporting contacts in the "Mail Mint Pro" plugin.
 *
 * @since 1.5.0
 */
class WPRoute extends AdminRoute {

	/**
	 * Route base.
	 *
	 * @var string The base route for exporting contacts.
	 * @since 1.5.0
	 */
	protected $rest_base = 'wp';

	/**
	 * ContactExportController class object.
	 *
	 * @var object An instance of the ContactExportController class.
	 * @since 1.5.0
	 */
	protected $controller;

	/**
	 * Initialize responsible controller for this route.
	 *
	 * @since 1.5.0
	 */
	public function __construct() {
		$this->controller = new WPController();
	}

	/**
	 * Register API endpoints routes for contacts export.
	 *
	 * Description: Registers the REST API routes for exporting contacts.
	 *
	 * @return void
	 * @since 1.5.0
	 */
	public function register_routes() {

		// Route for getting contact export fields.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/categories/search',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_wordpress_categories' ),
					'permission_callback' => '__return_true',
				),
			)
		);

		// Route for previewing contact export.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/tags/search',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_wordpress_tags' ),
					'permission_callback' => '__return_true',
				),
			)
		);

		// Route for exporting all contacts.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/author/search',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_wordpress_authors' ),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/admin/search',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array($this->controller,'get_email'),
					'permission_callback' => '__return_true',
				),
			)
		);
	}
}
