<?php

/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-09-27 11:03:17
 * @modify date 2024-09-27 11:03:17
 * @package MailMintPro\Mint\Admin\API\Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MailMintPro\Mint\Admin\API\Controllers\WCController;
use WP_REST_Server;

/**
 * Class WCRoute
 *
 * Summary: WooCommerce Route.
 * Description: Extends the AdminRoute class and handles API endpoints for
 *
 * @since 1.6.1
 */
class WCRoute extends AdminRoute{
    /**
     * Route base.
     *
     * @var string The base route for exporting contacts.
     * @since 1.6.1
     */
    protected $rest_base = 'wc';

    /**
     * WCController class object.
     *
     * @var object An instance of the WCController class.
     * @since 1.6.1
     */
    protected $controller;

    /**
     * Initialize responsible controller for this route.
     *
     * @since 1.6.1
     */
    public function __construct()
    {
        $this->controller = new WCController();
    }

    /**
     * Register API endpoints routes to retrieve WooCommerce coupons.
     *
     * @return void
     * @since 1.6.1
     */
    public function register_routes(){
        register_rest_route(
            $this->namespace,
            $this->rest_base . '/coupons',
            array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array($this->controller, 'get_coupons'),
                    'permission_callback' => '__return_true',
                ),
            )
        );
    }
}
