<?php
/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-05-02 11:03:17
 * @modify date 2024-05-02 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MailMintPro\Mint\Admin\API\Controllers\LeadMagnetController;
use Mint\MRM\Utilities\Helper\PermissionManager;
use WP_REST_Server;

/**
 * LeadMagnetRoute class for handling REST API routes related to lead magnets.
 *
 * @desc This class extends the AdminRoute class and is responsible for registering REST API routes.
 * @package /app/API/Routes
 * @since 1.11.0
 */
class LeadMagnetRoute extends AdminRoute {

	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.11.0
	 */
	protected $rest_base = 'lead-magnets';


	/**
	 * Instance of the LeadMagnetController class for handling route callbacks.
	 *
	 * @var object
	 * @since 1.11.0
	 */
	protected $controller;

	/**
	 * Constructor for the LeadMagnetRoute class.
	 *
	 * Initializes the controller instance with an LeadMagnetController object.
	 *
	 * @since 1.11.0
	 */
	public function __construct() {
		$this->controller = new LeadMagnetController();
	}

	/**
	 * Register REST API routes for lead magnets.
	 *
	 * @return void
	 * @since 1.11.0
	 */
	public function register_routes() {

		/**
		 * Lead magnet create endpoint
		 * Lead magnet get all endpoint
		 *
		 * @return void
		 * @since 1.11.0
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base,
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'create_or_update' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_all' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);

		/**
		 * Lead magnet get single endpoint
		 *
		 * @return void
		 * @since 1.11.0
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<magnet_id>[\d]+)',
			array(
				array(
					'methods'             => WP_REST_Server::EDITABLE,
					'callback'            => array( $this->controller, 'create_or_update' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_single' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<magnet_id>[\d]+)/delete',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'delete_single' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);
	}

}
