<?php
/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-19-01 11:03:17
 * @modify date 2024-19-01 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use Mint\MRM\Utilities\Helper\PermissionManager;
use MintMailPro\Mint\Admin\API\Controllers\AnalyticsController;
use MintMailPro\Mint\Admin\API\Controllers\Integration\IntegrationController;
use WP_REST_Server;

/**
 * AnalyticsRoute class for handling REST API routes related to campaign analytics.
 *
 * This class extends the AdminRoute class and is responsible for registering REST API routes
 * related to campaign analytics. It includes a controller instance for handling the route callbacks.
 *
 * @since 1.9.0
 */
class IntegrationRoute extends AdminRoute {

	/**
	 * The REST base for campaign analytics routes.
	 *
	 * @var string
	 * @since 1.9.0
	 */
	protected $rest_base = 'integration';

	/**
	 * Instance of the AnalyticsController class for handling route callbacks.
	 *
	 * @var AnalyticsController
	 * @since 1.9.0
	 */
	protected $controller;

	/**
	 * Constructor for the AnalyticsRoute class.
	 *
	 * Initializes the controller instance with an AnalyticsController object.
	 *
	 * @since 1.9.0
	 */
	public function __construct() {
		$this->controller = new IntegrationController();
	}

	/**
	 * Register REST API routes for campaign analytics.
	 *
	 * Registers a readable route for retrieving campaign analytics
	 * data based on the provided campaign ID.
	 *
	 * @since 1.9.0
	 */
	public function register_routes() {

		/**
		 * Register REST route for retrieving campaign analytics data.
		 *
		 * @since 1.9.0
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base,
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_integrations'),
				),
			)
		);

        register_rest_route(
			$this->namespace,
			$this->rest_base,
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'connect' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_integrations'),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/disconnect',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'disconnect' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_integrations'),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/zerobounce/apply',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'apply_zero_bounce' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_integrations'),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/twilio/send-test-message',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'send_test_message' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_integrations'),
				),
			)
		);
	}
}
