<?php

/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-11-29 11:03:17
 * @modify date 2024-11-29 11:03:17
 * @package MailMintPro\Mint\Admin\API\Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MailMintPro\Mint\Admin\API\Controllers\FormController;
use Mint\MRM\Utilities\Helper\PermissionManager;
use WP_REST_Server;

/**
 * Class FormRoute
 *
 * Summary: Form route.
 * Description: Extends the AdminRoute class and handles API endpoints for
 *
 * @since 1.17.0
 */
class FormRoute extends AdminRoute{
    /**
     * Route base.
     *
     * @var string The base route for the form module.
     * @since 1.17.0
     */
    protected $rest_base = 'forms';

    /**
     * FormController class object.
     *
     * @var object An instance of the FormController class.
     * @since 1.17.0
     */
    protected $controller;

    /**
     * Initialize responsible controller for this route.
     *
     * @since 1.17.0
     */
    public function __construct(){
        $this->controller = new FormController();
    }

    /**
     * Register API endpoints routes to export form data.
     *
     * @return void
     * @since 1.17.0
     */
    public function register_routes(){
        register_rest_route(
            $this->namespace, $this->rest_base . '/(?P<id>[\d]+)/export',
            array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array($this->controller, 'export_form'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_forms_export'),
                ),
            )
        );

        register_rest_route(
			$this->namespace, $this->rest_base . '/import',
			array(
				array(
					'methods'             => WP_REST_Server::EDITABLE,
					'callback'            => array( $this->controller, 'import_form' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_forms'),
				),
			)
		);
    }
}
