<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MintMailPro\Mint\Admin\API\Controllers\EmailBuilderController;
use WP_REST_Server;

/**
 * Manages Analytics module API
 *
 * @package /app/API/Routes
 * @since 1.0.0
 */
class EmailBuilderRoute {
	/**
	 * Endpoint namespace.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	protected $namespace = 'mrm/v1';

	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.0.0
	 */
	protected $rest_base = '/';


	/**
	 * AnalyticsController class object
	 *
	 * @var object
	 * @since 1.0.0
	 */
	protected $controller;



	/**
	 * Register API endpoints routes for email builder blocks
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function register_routes() {
		$this->controller = new EmailBuilderController();

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/products',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_all_products',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/products/(?P<category_id>[\d]+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_latest_published_products_by_category',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/product/(?P<product_id>[\d]+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_published_product_by_id',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/posts/(?P<post_type>[a-zA-Z0-9_-]+)/(?P<category_id>[\d]+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_latest_published_post_by_category',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/posts/(?P<post_type>[a-zA-Z0-9_-]+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_all_posts',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/posts/(?P<post_type>[a-zA-Z0-9_-]+)/recent',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_recent_posts',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/post/(?P<post_type>[a-zA-Z0-9_-]+)/(?P<post_id>[\d]+)',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_published_post_by_id',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<post_type>[a-zA-Z0-9_-]+)/categories',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_categories_by_post',
					),
					'permission_callback' => '__return_true',
				),
			)
		);

		/**
		 * Register a REST route to retrieve a random product from the shop.
		 *
		 * @since 1.5.5
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/products/rand',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'retrieve_random_shop_products',
					),
					'permission_callback' => '__return_true',
				),
			)
		);
	}
}
