<?php

/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-11-30 11:03:17
 * @modify date 2024-11-30 11:03:17
 * @package MailMintPro\Mint\Admin\API\Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MailMintPro\Mint\Admin\API\Controllers\CustomAccessController;
use Mint\MRM\Utilities\Helper\PermissionManager;
use WP_REST_Server;

/**
 * Class RoleManagementRoute
 *
 * Summary: Role and Permissions route.
 * Description: Extends the AdminRoute class and handles API endpoints for
 *
 * @since 1.17.0
 */
class CustomAccessRoute extends AdminRoute{
    /**
     * Route base.
     *
     * @var string The base route for the role management module.
     * @since 1.17.0
     */
    protected $rest_base = 'custom-access';

    /**
     * RoleController class object.
     *
     * @var object An instance of the RoleController class.
     * @since 1.17.0
     */
    protected $controller;

    /**
     * Initialize responsible controller for this route.
     *
     * @since 1.17.0
     */
    public function __construct()
    {
        $this->controller = new CustomAccessController();
    }

    /**
     * Register API endpoints routes to export form data.
     *
     * @return void
     * @since 1.17.0
     */
    public function register_routes()
    {
        register_rest_route(
            $this->namespace,
            $this->rest_base,
            array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array($this->controller, 'get_custom_access'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
                ),
            )
        );

        register_rest_route(
            $this->namespace,
            $this->rest_base . '/(?P<id>[\d]+)',
            array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array($this->controller, 'get_users_and_permissions'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
                ),
            )
        );

        register_rest_route(
            $this->namespace,
            $this->rest_base,
            array(
                array(
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => array($this->controller, 'assign_custom_access'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
                ),
            )
        );

        register_rest_route(
            $this->namespace,
            $this->rest_base . '/(?P<id>[\d]+)',
            array(
                array(
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => array($this->controller, 'update_custom_access'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
                ),
            )
        );

        register_rest_route(
            $this->namespace,
            $this->rest_base . '/(?P<id>[\d]+)/delete',
            array(
                array(
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => array($this->controller, 'delete_custom_access'),
                    'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
                ),
            )
        );
    }
}
