<?php
/**
 * Mail Mint
 *
 * @author [getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-12-07 11:03:17
 * @modify date 2023-12-07 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use Mint\MRM\Utilities\Helper\PermissionManager;
use MintMailPro\Mint\Admin\API\Controllers\ContactProfileController;
use WP_REST_Server;

/**
 * [Handle contact profile related API callbacks]
 *
 * @desc Handle contact profile related API callbacks
 * @package /app/Admin/API/Routes
 * @since 1.6.1
 */
class ContactProfileRoute extends AdminRoute {

	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.6.1
	 */
	protected $rest_base = 'contacts';

	/**
	 * ContactProfileController class object
	 *
	 * @var ContactProfileController
	 */
	protected $controller;

	/**
	 * Initialize responsible controller for this route
	 */
	public function __construct() {
		$this->controller = new ContactProfileController();
	}

	/**
	 * Register API endpoints routes for contact related forms
	 *
	 * @return void
	 * @since 1.6.1
	 */
	public function register_routes() {

		/**
		 * Register the REST API route to retrieve WC purchase history
		 *
		 * @return void
		 * @since 1.6.1
		*/
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<contact_id>[\d]+)/purchases/wc',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_contact_woocommerce_purchase_history' ),
					'permission_callback' => PermissionManager::current_user_can('mint_read_contacts'),
				),
			)
		);

		/**
		 * Register the REST API route to retrieve EDD purchase history
		 *
		 * @return void
		 * @since 1.6.1
		*/
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<contact_id>[\d]+)/purchases/edd',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_contact_edd_purchase_history' ),
					'permission_callback' => PermissionManager::current_user_can('mint_read_contacts'),
				),
			)
		);

		/**
		 * Register the REST API route to retrieve contact high-level overview
		 *
		 * @return void
		 * @since 1.7.0
		*/
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/(?P<contact_id>[\d]+)/overview',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_contact_overview' ),
					'permission_callback' => PermissionManager::current_user_can('mint_read_contacts'),
				),
			)
		);
	}

}
