<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-07-20 11:03:17
 * @modify date 2023-07-20 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use Mint\MRM\Utilities\Helper\PermissionManager;
use MintMailPro\Mint\Admin\API\Controllers\ContactExportController;
use WP_REST_Server;

/**
 * Class ContactExportRoute
 *
 * Summary: Contact Export Route.
 * Description: Extends the AdminRoute class and handles API endpoints for exporting contacts in the "Mail Mint Pro" plugin.
 *
 * @since 1.5.0
 */
class ContactExportRoute extends AdminRoute {

	/**
	 * Route base.
	 *
	 * @var string The base route for exporting contacts.
	 * @since 1.5.0
	 */
	protected $rest_base = 'contacts/export';

	/**
	 * ContactExportController class object.
	 *
	 * @var object An instance of the ContactExportController class.
	 * @since 1.5.0
	 */
	protected $controller;

	/**
	 * Initialize responsible controller for this route.
	 *
	 * @since 1.5.0
	 */
	public function __construct() {
		$this->controller = new ContactExportController();
	}

	/**
	 * Register API endpoints routes for contacts export.
	 *
	 * Description: Registers the REST API routes for exporting contacts.
	 *
	 * @return void
	 * @since 1.5.0
	 */
	public function register_routes() {

		// Route for getting contact export fields.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/fields',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_contact_export_fields' ),
					'permission_callback' => PermissionManager::current_user_can('mint_read_contacts'),
				),
			)
		);

		// Route for previewing contact export.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/preview',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'get_contact_export_preview' ),
					'permission_callback' => PermissionManager::current_user_can('mint_read_contacts'),
				),
			)
		);

		// Route for exporting all contacts.
		register_rest_route(
			$this->namespace,
			$this->rest_base,
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'export_all_contacts' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_contacts_export'),
				),
			)
		);

		// Route for downloading file.
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/download',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'download_csv_file' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_contacts_export'),
				),
			)
		);
	}
}
