<?php
/**
 * Mail Mint
 *
 * @author [MailMint Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use Mint\MRM\Utilities\Helper\PermissionManager;
use MintMailPro\Mint\Admin\API\Controllers\AbandonedCartSettingController;

use WP_REST_Server;

/**
 * [Handle AbandonedCart related API callbacks]
 *
 * @desc Handle Webhook Module related API callbacks
 * @package /app/API/Routes
 * @since 1.0.0
 */
class AbandonedCartSettingRoute extends AdminRoute {
	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.5.0
	 */
	protected $rest_base = 'settings';

	/**
	 * AbandonedCartController class object
	 *
	 * @var AbandonedCartSettingController
	 * @since 1.5.0
	 */
	protected $controller;

	/**
	 * Initializes a new instance of the class and sets the controller.
	 *
	 * @since 1.5.0
	 */
	public function __construct() {
		$this->controller = new AbandonedCartSettingController();
	}

	/**
	 * Register API endpoints routes for AbandonedCart
	 *
	 * @return void
	 * @since 1.5.0
	 */
	public function register_routes() {
		/**
		 * Webhook create endpoint
		 * Get segments endpoint
		 *
		 * @return void
		 * @since 1.5.0
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/abandoned-cart',
			array(
				array(
					'methods'             => WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'insert_or_update' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);
	}
}
