<?php
/**
 * Mail Mint
 *
 * @author [MailMint Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use MintMailPro\Mint\Admin\API\Controllers\AbandonedCartFrontendController;

/**
 * [Handle AbandonedCart related API callbacks]
 *
 * @desc Handle Webhook Module related API callbacks
 * @package /app/API/Routes
 * @since 1.0.0
 */
class AbandonedCartFrontendRoute {

	/**
	 * Endpoint namespace.
	 *
	 * @var string
	 * @since 1.5.0
	 */
	protected $namespace = 'mail-mint/v1';

	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.5.0
	 */
	protected $rest_base = 'abandoned-cart';


	/**
	 * AbandonedCartFrontendController class object
	 *
	 * @var AbandonedCartFrontendController
	 * @since 1.5.0
	 */

	protected $controller;

	/**
	 * Register API endpoints routes for AbandonedCart
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function register_routes() {
		$this->controller = new AbandonedCartFrontendController();
		/**
		 * Webhook create endpoint
		 * Get segments endpoint
		 *
		 * @return void
		 * @since 1.5.0
		 */
		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/update-checkout',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array(
						$this->controller,
						'update_checkout',
					),
					'permission_callback' => array(
						$this->controller,
						'rest_permissions_check',
					),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/skip-track',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array(
						$this->controller,
						'delete_abandoned_cart',
					),
					'permission_callback' => array(
						$this->controller,
						'rest_permissions_check',
					),

					'args'                => array(
						'wp_nonce' => array(
							'type'     => 'string',
							'required' => true,
						),
						'email'    => array(
							'type'     => 'string',
							'required' => true,
						),
					),
				),
			)
		);
	}
}
