<?php
/**
 * Mail Mint
 *
 * @author [MailMint Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Admin/API/Routes
 */

namespace MailMintPro\Mint\Admin\API\Routes;

use Mint\MRM\Utilities\Helper\PermissionManager;
use MintMailPro\Mint\Admin\API\Controllers\AbandonedCartAdminController;
use WP_REST_Server;
/**
 * Manages  AbandonedCart admin Route
 *
 * @package /app/API/Controllers
 * @since 1.5.0
 */
class AbandonedCartAdminRoute extends AdminRoute {
	/**
	 * Route base.
	 *
	 * @var string
	 * @since 1.5.0
	 */
	protected $rest_base = 'abandoned-cart';

	/**
	 * AbandonedCartController class object
	 *
	 * @var AbandonedCartAdminController
	 * @since 1.5.0
	 */
	protected $controller;

	/**
	 * Initializes a new instance of the class and sets the controller.
	 *
	 * @since 1.5.0
	 */
	public function __construct() {
		$this->controller = new AbandonedCartAdminController();
	}
	/**
	 * Register API endpoints routes for AbandonedCart
	 *
	 * @return void
	 * @since 1.5.0
	 */
	public function register_routes() {
		/**
		 * Abandoned create endpoint
		 * Get segments endpoint
		 *
		 * @return void
		 * @since 1.5.0
		 */
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/recoverable',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_recoverable_carts' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),

			),
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/recoverable/delete',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array( $this->controller, 'delete_all' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),

			),
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/recovered',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_recovered_carts' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			),
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/recovered/delete',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array(
						$this->controller,
						'delete_all',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),

			),
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/lost',
			array(
				array(
					'methods'             => WP_REST_Server::READABLE,
					'callback'            => array( $this->controller, 'get_losts_carts' ),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			),
		);

		register_rest_route(
			$this->namespace,
			$this->rest_base . '/lost/delete',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array(
						$this->controller,
						'delete_all',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			),
		);

		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/(?P<abandoned_id>[\d]+)/delete',
			array(
				array(
					'methods'             => \WP_REST_Server::CREATABLE,
					'callback'            => array(
						$this->controller,
						'delete_single',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);

		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/automation/(?P<abandoned_id>[\d]+)',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_abandoned_automations',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);
		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/analytics/',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_reports',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings'),
				),
			)
		);
		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/abandoned-automation/',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'get_all_abandoned_automations',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_settings')
				),
			)
		);
		register_rest_route(
			$this->namespace,
			'/' . $this->rest_base . '/manually-run-automation/(?P<abandoned_id>[\d]+)/(?P<automation_id>[\d]+)',
			array(
				array(
					'methods'             => \WP_REST_Server::READABLE,
					'callback'            => array(
						$this->controller,
						'run_abandoned_automation_manually',
					),
					'permission_callback' => PermissionManager::current_user_can('mint_manage_automations'),
					'args'                => array(
						'abandoned_id'  => array(
							'type'     => 'integer',
							'required' => true,
						),
						'automation_id' => array(
							'type'     => 'integer',
							'required' => true,
						),
					),
				),
			)
		);
	}
}
