<?php
/**
 * Mail Mint
 *
 * @author [getwpfunnels team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-07-20 11:03:17
 * @modify date 2023-07-20 11:03:17
 * @package /app/Admin/API/Creators
 */

namespace MintMailPro\Mint\Admin\API\Creators;

use Mint\MRM\API\Actions\ActionCreator;
use MintMailPro\Mint\Admin\API\Actions\ContactProfileAction;

/**
 * Class ContactProfileActionCreator
 *
 * Summary: Contact Profile Action Creator.
 * Description: Extends the ActionCreator class and creates a new instance of the ContactProfileAction class.
 *
 * @since 1.6.1
 */
class ContactProfileActionCreator extends ActionCreator {

	/**
	 * Create a new instance of the ContactProfileAction class.
	 *
	 * Description: Creates and returns a new instance of the ContactProfileAction class.
	 *
	 * @access public
	 *
	 * @return ContactProfileAction A new instance of the ContactProfileAction class.
	 * @since 1.6.1
	 */
	public function makeAction() {
		return new ContactProfileAction();
	}
}
