<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-07-20 11:03:17
 * @modify date 2023-07-20 11:03:17
 * @package /app/Admin/API/Creators
 */

namespace MintMailPro\Mint\Admin\API\Creators;

use Mint\MRM\API\Actions\ActionCreator;
use MintMailPro\Mint\Admin\API\Actions\ContactExportAction;

/**
 * Class ContactExportActionCreator
 *
 * Summary: Contact Export Action Creator.
 * Description: Extends the ActionCreator class and creates a new instance of the ContactExportAction class.
 *
 * @since 1.5.0
 */
class ContactExportActionCreator extends ActionCreator {

	/**
	 * Create a new instance of the ContactExportAction class.
	 *
	 * Description: Creates and returns a new instance of the ContactExportAction class.
	 *
	 * @access public
	 *
	 * @return ContactExportAction A new instance of the ContactExportAction class.
	 * @since 1.5.0
	 */
	public function makeAction() {
		return new ContactExportAction();
	}
}
