<?php
/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-01-20 11:03:17
 * @modify date 2024-01-20 11:03:17
 * @package /app/Admin/API/Creators
 */

namespace MintMailPro\Mint\Admin\API\Creators;

use Mint\MRM\API\Actions\ActionCreator;
use MintMailPro\Mint\Admin\API\Actions\AnalyticsAction;

/**
 * AnalyticsActionCreator class for creating instances of AnalyticsAction.
 *
 * This class extends the ActionCreator and is responsible for creating instances
 * of the AnalyticsAction class. It provides a method to make an AnalyticsAction
 * instance, which can be used to handle analytics-related actions.
 *
 * @since 1.9.0
 */
class AnalyticsActionCreator extends ActionCreator {

	/**
	 * Create an instance of AnalyticsAction.
	 *
	 * This method creates and returns a new instance of the AnalyticsAction class.
	 *
	 * @return AnalyticsAction An instance of the AnalyticsAction class.
	 *
	 * @since 1.9.0
	 */
	public function makeAction() {
		return new AnalyticsAction();
	}
}
