<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Admin/API/Controllers
 */

namespace MintMailPro\Mint\Admin\API\Controllers;

use MailMint\App\Helper;
use MintMailPro\Mint_Pro_Helper;
use MailMintPro\Mint\Internal\Traits\Singleton;
use MailPoet\AdminPages\Pages\Help;
use Mint\MRM\Admin\API\Controllers\MessageController;
use Mint\MRM\DataBase\Models\CampaignModel;
use Mint\MRM\DataBase\Models\ContactModel;
use MRM\Common\MrmCommon;
use WP_REST_Controller;
use WP_REST_Request;

/**
 * Manages product API callbacks
 *
 * @package /app/API/Controllers
 * @since 1.0.0
 */
class ProductController extends WP_REST_Controller {

	use Singleton;


	/**
	 * Request for search product
	 *
	 * @param WP_REST_Request $request Request.
	 * @return WP_REST_Response
	 * @since 1.0.0
	 */
	public function get_product( WP_REST_Request $request ) {
		$response             = array();
		$params               = MrmCommon::get_api_params_values( $request );
		$term                 = isset( $params['term'] ) ? $params['term'] : '';
		$type                 = isset( $params['type'] ) ? $params['type'] : 'wc';
		$products             = Mint_Pro_Helper::retrieve_product( $term, $type );
		$response['success']  = true;
		$response['products'] = $products;
		return rest_ensure_response( $response );
	}

	/**
	 * Request for Category product
	 *
	 * @param WP_REST_Request $request Request.
	 * @return WP_REST_Response
	 * @since 1.5.4
	 */
	public function get_category( WP_REST_Request $request ) {
		$response             = array();
		$params               = MrmCommon::get_api_params_values( $request );
		$term                 = isset( $params['term'] ) ? $params['term'] : '';
		$type                 = isset( $params['type'] ) ? $params['type'] : 'wc';
		$category             = Mint_Pro_Helper::retrieve_category( $term, $type );
		$response['success']  = true;
		$response['category'] = $category;
		return rest_ensure_response( $response );
	}

	/**
	 * Request for Tags product
	 *
	 * @param WP_REST_Request $request Request.
	 * @return WP_REST_Response
	 * @since 1.15.5
	 */
	public function get_tags( WP_REST_Request $request ) {
		$response             = array();
		$params               = MrmCommon::get_api_params_values( $request );
		$term                 = isset( $params['term'] ) ? $params['term'] : '';
		$type                 = isset( $params['type'] ) ? $params['type'] : 'wc';
		$tags                 = Mint_Pro_Helper::retrieve_tags( $term, $type );
		$response['success']  = true;
		$response['tags']     = $tags;
		return rest_ensure_response( $response );
	}


	/**
	 * User accessability check for REST API
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	public function rest_permissions_check() {
		return true;
	}

}
