<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Admin/API/Controllers
 */

namespace MintMailPro\Mint\Admin\API\Controllers;

use MintMailPro\Mint_Pro_Helper;
use MRM\Common\MrmCommon;
use WP_REST_Controller;
use WP_REST_Request;

/**
 * Manages product API callbacks
 *
 * @package /app/API/Controllers
 * @since 1.0.0
 */
class LMSController extends WP_REST_Controller {

	/**
	 * Retrieve courses based on the provided parameters.
	 *
	 * @param WP_REST_Request $request The REST API request object.
	 *
	 * @return WP_REST_Response The response containing the success status and the list of courses.
	 * @since 1.17.2
	 */
	public function get_courses( WP_REST_Request $request ) {
		$response            = array();
		$params              = MrmCommon::get_api_params_values( $request );
		$term                = isset( $params['term'] ) ? $params['term'] : '';
		$type                = isset( $params['type'] ) ? $params['type'] : 'sfwd-courses';
		$courses             = Mint_Pro_Helper::retrieve_lms_courses( $term, $type );
		$response['success'] = true;
		$response['courses'] = $courses;
		return rest_ensure_response( $response );
	}

	/**
	 * Retrieve groups based on the provided parameters.
	 *
	 * @param WP_REST_Request $request The REST API request object.
	 *
	 * @return WP_REST_Response The response containing the success status and the list of groups.
	 * @since 1.17.2
	 */
	public function get_groups( WP_REST_Request $request ) {
		$response            = array();
		$params              = MrmCommon::get_api_params_values( $request );
		$term                = isset( $params['term'] ) ? $params['term'] : '';
		$type                = isset( $params['type'] ) ? $params['type'] : 'groups';
		$category            = Mint_Pro_Helper::retrieve_lms_groups( $term, $type );
		$response['success'] = true;
		$response['groups']  = $category;
		return rest_ensure_response( $response );
	}
}
