<?php
/**
 * Mail Mint
 *
 * @author [getwpfunnels team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-07-20 11:03:17
 * @modify date 2023-07-20 11:03:17
 * @package /app/Admin/API/Controllers
 */

namespace MintMailPro\Mint\Admin\API\Controllers;

use Mint\MRM\Admin\API\Controllers\AdminBaseController;
use MintMailPro\Mint\Admin\API\Creators\ContactProfileActionCreator;
use MRM\Common\MrmCommon;
use WP_REST_Request;
use WP_REST_Response;

/**
 * Class ContactProfileController
 * Extends AdminBaseController and provides methods for handling contact profile related functionalities.
 *
 * @since 1.6.1
 */
class ContactProfileController extends AdminBaseController {

	/**
	 * The ContactProfileActionCreator instance used to create ContactProfileAction objects.
	 *
	 * @var ContactProfileActionCreator
	 * @access protected
	 * @since 1.6.1
	 */
	protected $creator;

	/**
	 * The ContactProfileAction instance used for performing contact profile actions.
	 *
	 * @var ContactProfileAction
	 * @access protected
	 * @since 1.6.1
	 */
	protected $action;

	/**
	 * ContactProfileActionCreator constructor.
	 *
	 * This constructor initializes the ContactProfileActionCreator and ContactProfileAction objects,
	 * making them accessible within the class for further use.
	 *
	 * @access public
	 * @since 1.6.1
	 */
	public function __construct() {
		$this->creator = new ContactProfileActionCreator();
		$this->action  = $this->creator->makeAction();
	}

	/**
	 * Get the WooCommerce purchase history for a contact.
	 *
	 * @param WP_REST_Request $request The WordPress REST API request object.
	 *
	 * @return WP_REST_Response A REST API response containing the status, data, and a message.
	 * @since 1.6.1
	 */
	public function get_contact_woocommerce_purchase_history( WP_REST_Request $request ) {
		// Get API parameters from the request object and filter them.
		$params = MrmCommon::prepare_request_params( $request );
		$params = filter_var_array( $params );

		$response = $this->action->get_contact_woocommerce_purchase_history( $params );
		// Get the data for the WooCommerce purchase history.
		return new WP_REST_Response(
			array(
				'status'  => 'success',
				'data'    => $response,
				'message' => __( 'Data have been retrieved successfully.', 'mailmint-pro' ),
			)
		);
	}

	/**
	 * Get the EDD purchase history for a contact.
	 *
	 * @param WP_REST_Request $request The WordPress REST API request object.
	 *
	 * @return WP_REST_Response A REST API response containing the status, data, and a message.
	 * @since 1.6.1
	 */
	public function get_contact_edd_purchase_history( WP_REST_Request $request ) {
		// Get API parameters from the request object and filter them.
		$params = MrmCommon::prepare_request_params( $request );
		$params = filter_var_array( $params );

		$response = $this->action->get_contact_edd_purchase_history( $params );
		// Get the data for the WooCommerce purchase history.
		return new WP_REST_Response(
			array(
				'status'  => 'success',
				'data'    => $response,
				'message' => __( 'Data have been retrieved successfully.', 'mailmint-pro' ),
			)
		);
	}

	/**
	 * Summary: Retrieves contact overview data via the REST API.
	 *
	 * Description: This method is a REST API endpoint for retrieving contact overview data.
	 *
	 * @access public
	 *
	 * @param WP_REST_Request $request The REST API request object containing parameters for retrieving contact overview data.
	 *
	 * @return WP_REST_Response Returns a WP_REST_Response object containing the formatted response.
	 *
	 * @since 1.7.0
	 */
	public function get_contact_overview( WP_REST_Request $request ) {
		// Get API parameters from the request object and filter them.
		$params = MrmCommon::prepare_request_params( $request );
		$params = filter_var_array( $params );

		// Invoke the 'get_contact_overview' method of the associated action class.
		$response = $this->action->get_contact_overview( $params );

		// Format the response as a WP_REST_Response.
		return new WP_REST_Response(
			array(
				'status'  => 'success',
				'data'    => $response,
				'message' => __( 'Data have been retrieved successfully.', 'mailmint-pro' ),
			)
		);
	}
}
