<?php
/**
 * REST API Contact Controller
 *
 * Handles requests to the contacts endpoint.
 *
 * @author   MRM Team
 * @category API
 * @package  MRM
 * @since    1.0.0
 */

namespace MintMailPro\Mint\Admin\API\Controllers;

use MailMintPro\Mint\Internal\Traits\Singleton;
use Mint\MRM\Admin\API\Controllers\MessageController;
use WP_REST_Request;
use WP_REST_Controller;

/**
 * This is the main class that controls the contacts feature. Its responsibilities are:
 *
 * - Create or update a contact
 * - Delete single or multiple contacts
 * - Retrieve single or multiple contacts
 * - Assign or removes tags and lists from the contact
 *
 * @package Mint\MRM\Admin\API\Controllers
 */
class ContactController extends WP_REST_Controller {

	use Singleton;

	/**
	 * Send a message to contact
	 *
	 * @param WP_REST_Request $request Request object used to generate the response.
	 *
	 * @return WP_REST_Response
	 * @since 1.0.0
	 */
	public function send_message( WP_REST_Request $request ) {
		return MessageController::get_instance()->create_or_update( $request );
	}


	/**
	 * User accessability check for REST API
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	public function rest_permissions_check() {
		return true;
	}

}
