<?php
/**
 * Mail Mint
 *
 * @package /app/Admin/API/Controllers
 *
 * @since 1.5.0
 *
 * @author [MailMint Team]
 * @email [support@getwpfunnels.com]
 */

namespace MintMailPro\Mint\Admin\API\Controllers;

use MailMintPro\Mint\Internal\AbandonedCart\Helper\Common;
use MRM\Common\MrmCommon;
use WP_REST_Controller;
use WP_REST_Request;

/**
 * Manages  AbandonedCart API callbacks
 *
 * @package /app/API/Controllers
 * @since 1.5.0
 */
class AbandonedCartSettingController extends WP_REST_Controller {

	/**
	 * The option key used to store the abandoned cart settings.
	 *
	 * @var string
	 * @since 1.5.0
	 */
	private $option_key = '_mint_abandoned_cart_settings';

	/**
	 * Insert or update the abandoned cart settings based on the provided request parameters.
	 *
	 * @param WP_REST_Request $request The REST request object.
	 *
	 * @return WP_REST_Response The REST response object.
	 * @since 1.5.0
	 */
	public function insert_or_update( WP_REST_Request $request ) {
		$params = MrmCommon::get_api_params_values( $request );

		// Check if the parameters are missing or empty.
		if ( !is_array( $params ) || empty( $params ) ) {
			return rest_ensure_response(
				array(
					'success' => false,
					'message' => __( 'Missing or empty parameters', 'mailmint-pro' ),
				)
			);
		}

		// Check if the '_locale' parameter is set before unsetting it.
		if ( isset( $params['_locale'] ) ) {
			unset( $params['_locale'] );
		}

		// Update the abandoned cart settings with the provided parameters.
		update_option( $this->option_key, $params );
		return rest_ensure_response(
			array(
				'success' => true,
				'message' => __( 'Abandoned cart settings have been successfully saved.', 'mailmint-pro' ),
			)
		);
	}

	/**
	 * Retrieve the abandoned cart settings.
	 * If no settings are found, it returns an error response.
	 *
	 * @return WP_REST_Response The response containing the abandoned cart settings.
	 * @since 1.5.0
	 */
	public function get() {
		$settings = get_option( $this->option_key, Common::abandoned_cart_default_configuration() );
		if ( !is_array( $settings ) || empty( $settings ) ) {
			return rest_ensure_response(
				array(
					'success' => false,
					'message' => __( 'No settings found', 'mailmint-pro' ),
				)
			);
		}

		return rest_ensure_response(
			array(
				'success' => true,
				'results' => $settings,
			)
		);
	}
}
