<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-07 15:33:17
 * @modify date 2025-01-07 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;
use MintMail\App\Internal\Automation\HelperFunctions;
use Jet_Form_Builder\Classes\Tools;

/**
 * Connector handler for  MemberPress
 *
 * This class handles API requests related to  MemberPress, including fetching available forms
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality for  MemberPress
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.17.4
 */
class MemberPressConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of  MemberPress.
     *
     * Fetches all  MemberPress based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of forms.
     * @since 1.17.4
     */
    public function get($params) {
        if (HelperFunctions::is_memberpress_active()) {
            $search = $params['search'] ?? '';
            
            $extra_args = array( 's' => $search);
            $levels     = \MeprCptModel::all('MeprProduct', false, $extra_args);  
          
            $formatted = array();
            if (is_array($levels) && !empty($levels)) {
                foreach ($levels as $post) {
                    if (stripos($post->post_title, $search) !== false) {
                        $formatted[] = array(
                            'value' => $post->ID,
                            'label' => $post->post_title,
                        );
                    }
                }
            }
        
            $response = [
                'success' => true,
                'levels' => $formatted,   
            ];
            return $response;
        }
        return array();
    }

    /**
     * Retrieves fields from a specific Contact Form 7 form.
     *
     * Scans the specified  MemberPress for available fields and returns a formatted array
     * of field names and labels, excluding submit buttons and file upload fields.
     *
     * @param array $params An array of parameters for the request, including the form ID.
     *
     * @return array The response containing the list of fields.
     * @since 1.17.4
     */
    public function fields($params){
        return array();
    }

}