<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-16 15:33:17
 * @modify date 2025-01-16 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;

use MintMail\App\Internal\Automation\HelperFunctions;

/**
 * Connector handler for LearnDash topics.
 *
 * This class handles API requests related to LearnDash topics  , including fetching available  
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality forLearnDash topics.
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.17.4
 */
class LearndashTopicsConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of LearnDash topics  .
     *
     * Fetches allLearnDash topics   based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of topics .
     * @since 1.17.4
     */
    public function get($params) {
        $search = isset($params['search']) ? $params['search'] : '';
        return array();
    }

    /**
     * Retrieves fields from a specific LearnDash topics.
     *
     * Scans the specifiedLearnDash topics form for available fields and returns a formatted array
     * of field names and labels, excluding submit buttons and file upload fields.
     *
     * @param array $params An array of parameters for the request, including the form ID.
     *
     * @return array The response containing the list of fields.
     * @since 1.17.4
     */
    public function fields($params){
        $lesson_id = isset($params['id']) ? $params['id'] : '';

        if (HelperFunctions::is_learndash_lms_active()) {
            $formatted = array();
            $posts =  learndash_get_topic_list( $lesson_id );
            if ( is_array($posts) && !empty($posts) ) {
                foreach ($posts as $post) {
                    $formatted[] = array(
                        'value'  => $post->ID,
                        'label'  => $post->post_title,
                    );
                }
            }
            $response = [
                'success' => true,
                'topics'  => $formatted,
            ];
            return $response;
        }
        return array();
    }
}