<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-07 15:33:17
 * @modify date 2025-01-07 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;

use MintMail\App\Internal\Automation\HelperFunctions;

/**
 * Connector handler for LearnDash Quiz.
 *
 * This class handles API requests related to LearnDash Quiz forms, including fetching available forms
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality forLearnDash Quiz.
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.17.4
 */
class LearndashQuizConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of LearnDash Quiz forms.
     *
     * Fetches allLearnDash Quiz forms based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of forms.
     * @since 1.17.4
     */
    public function get($params) {
        $search = isset($params['search']) ? $params['search'] : '';

        if (HelperFunctions::is_learndash_lms_active()) {
            $formatted_forms = array();

            $posts = get_posts(
				array(
					'post_type'   => learndash_get_post_type_slug( 'quiz' ),
					'numberposts' => -1,
					'orderby'     => 'created_at',
					'order'       => 'DESC',
					'post_status' => 'publish',
                    's'           => $search,
				)
			);

            if ( is_array($posts) && !empty($posts) ) {
                foreach ($posts as $post) {
                    $formatted_forms[] = array(
                        'value'  => $post->ID,
                        'label'  => $post->post_title,
                    );
                }
            }
            $response = [
                'success' => true,
                'quizzes' => $formatted_forms,
            ];
            return $response;
        }
        return array();
    }

    /**
     * Retrieves fields from a specific LearnDash Quiz form.
     *
     * Scans the specifiedLearnDash Quiz form for available fields and returns a formatted array
     * of field names and labels, excluding submit buttons and file upload fields.
     *
     * @param array $params An array of parameters for the request, including the form ID.
     *
     * @return array The response containing the list of fields.
     * @since 1.17.4
     */
    public function fields($params){
        $id = isset($params['id']) ? $params['id'] : '';
        return array();

    }
}