<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-07 15:33:17
 * @modify date 2025-01-07 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;

/**
 * Connector handler for Learn Dash.
 *
 * This class handles API requests related to Learn Dash lessions, including fetching available forms
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality for Learn Dash.
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.17.4
 */
class LearndashLessonsConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of Learn Dash lessions.
     *
     * Fetches all Learn Dash lessions based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of forms.
     * @since 1.17.4
     */
    public function get($params) {
        return array();
    }

    /**
     * Retrieves lessions from a specific Learn Dash course .
     *
     * Scans the specified Learn Dash course for available lessions  and returns a formatted array
     *
     * @param array $params An array of parameters for the request, including the form ID.
     *
     * @return array The response containing the list of fields.
     * @since 1.17.4
     */
    public function fields($params){
        $id = isset($params['id']) ? $params['id'] : '';
		if ( !$id ) {
			return array();
		}
		$lessons = learndash_get_lesson_list( $id );

		$formatted_lessons = array();
		foreach ( $lessons as $lesson ) {
			$formatted_lessons[] = array(
				'value'  => strval( $lesson->ID ),
				'label'  => $lesson->post_title,
			);
		}
        $response = [
            'success' => true,
            'lessons' => $formatted_lessons 
        ];
		return $response;
    }
}