<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-07 15:33:17
 * @modify date 2025-01-07 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;
use MintMail\App\Internal\Automation\HelperFunctions;
use Jet_Form_Builder\Classes\Tools;

/**
 * Connector handler for Contact Form 7.
 *
 * This class handles API requests related to Contact Form 7 forms, including fetching available forms
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality for Contact Form 7.
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.17.4
 */
class JetFormsConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of Contact Form 7 forms.
     *
     * Fetches all Contact Form 7 forms based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of forms.
     * @since 1.17.4
     */
    public function get($params) {
        $search = isset($params['search']) ? $params['search'] : '';
        $formatted_forms = array();
        if (HelperFunctions::is_jetform_active()) {
        if ( class_exists( 'Jet_Form_Builder\Classes\Tools' ) ){

            $posts = get_posts(
                array(
                    'post_type'   => 'jet-form-builder',
                    'numberposts' => -1,
                    'orderby'     => 'created_at',
                    'order'       => 'DESC',
                    'post_status' => 'publish',
                    's'           => $search,
                )
            );

            if (is_array($posts) && !empty($posts)) {			
                foreach ($posts as $post) {
                    if (stripos($post->post_title, $search) !== false) {
                        $formatted_forms[] = array(
                            'value' => $post->ID,
                            'label' => $post->post_title,
                        );
                    }
                }
               }
              }
        }
        $response['success'] = true;
        $response['forms']   = $formatted_forms;
        return $response;
    }

    /**
     * Retrieves fields from a specific Contact Form 7 form.
     *
     * Scans the specified Contact Form 7 form for available fields and returns a formatted array
     * of field names and labels, excluding submit buttons and file upload fields.
     *
     * @param array $params An array of parameters for the request, including the form ID.
     *
     * @return array The response containing the list of fields.
     * @since 1.17.4
     */
    public function fields($params){
        $id = isset($params['id']) ? $params['id'] : '';
        $fields = array();
        if (HelperFunctions::is_jetform_active()) {
		$blocks = \Jet_Form_Builder\Blocks\Block_Helper::get_blocks_by_post( $id );

		if ( empty( $blocks ) || ! is_array( $blocks ) ) {
			return array();
		}
		foreach ($blocks as $block) {
			$attrs = isset($block['attrs']) ? $block['attrs'] : array();

			if( empty( $attrs ) || ! is_array( $blocks ) || empty( $block['blockName'] ) || empty( $attrs['label'] )  ) {
				continue;
			}

			$fields[] = array(
				'type'  => $block['blockName'],
				'label' => isset($attrs['label']) ? $attrs['label'] : '',
				'value' => isset($attrs['name']) ? $attrs['name'] : ''
			);
		}
     }
     $response['success'] = true;
     $response['fields']  = $fields;
     return $response; 
}

}