<?php
/**
 * Mail Mint Pro
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2025-01-08 15:33:17
 * @modify date 2025-01-08 15:33:17
 * @package MintMailPro\App\Admin\API\Actions\Connector;
 */
namespace MintMailPro\App\Admin\API\Actions\Connector;

/**
 * Connector handler for fluent booking.
 *
 * This class handles API requests related to Contact Form 7 booking, including fetching available booking
 * and their fields. It extends the `BaseConnectorHandler` to implement specific functionality for Contact Form 7.
 *
 * @package MintMailPro\App\Admin\API\Actions\Connector
 * @since 1.18.2
 */
class FluentBookingsConnectorHandler extends BaseConnectorHandler {

    /**
     * Retrieves a list of fluent booking.
     *
     * Fetches all fluent booking based on the search parameter. Returns a formatted array
     * containing the form ID and title for each matching form.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of booking.
     * @since 1.17.4
     */
	public function get($params) {
		global $wpdb;
		$table = $wpdb->prefix . 'fcal_calendar_events';

		$term   = isset($params['search']) ? $params['search'] : '';
		$search = '%' . $wpdb->esc_like($term) . '%';
	
		$calendars = array();
		$query     = $wpdb->prepare( "SELECT id as value, title as label FROM {$table} WHERE title LIKE %s AND status = 'active' ORDER BY title ASC", $search );
		$calendars = $wpdb->get_results($query, ARRAY_A);
		return [
			'success'   => true,
			'calendars' => $calendars
		];
	}

    /**
     * Retrieves single entry of fluent booking.
     *
     * @param array $params An array of parameters for the request.
     *
     * @return array The response containing the list of booking.
     * @since 1.17.4
     */
	public function fields( $params ) {
        $id = isset($params['id']) ? $params['id'] : '';
		return [
			'success' => true,
			'fields'  => array()
		];
	}
}
